
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  spi.h: SD/MMC card SPI communication functions
  Written by Mauro Grassi and updated by Nicholas Vinen, 2009-2013
*/

#ifndef SPI_H
#define SPI_H

#include "GenericTypeDefs.h"

// don't want DMA for the bootloader since it can't use interrupts as it needs to be able to reflash the interrupt table page
#ifndef BOOTLOADER
#define USE_DMA			1
#endif
#define SDCS			(LATFbits.LATF5)
#define SDCS_TRIS		(TRISFbits.TRISF5)

void 					DeinitSPI();
void 					InitSPI(int speed);
unsigned int 			WriteSPI(unsigned int x);
unsigned int 			WriteSPIWithoutSS(unsigned int x);
void					BulkReadSPI(BYTE* data);
void                    BulkReadSPIInto(unsigned char* buf);

#endif
